'6 October 2007
'Modified Chip's 1024x768 demo to show custom interleaved characters on XGA
'Modified the Print() function to print user characters (signalled by adding $200 to user character number)
'Also, provided uPrint() function to print user characters a more direct way

CON

  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000

  cols = 64
  rows = 48
  tiles = cols * rows

  spacetile = $8000 + $20 << 6

  bitmap_base = $4000
  display_base = $6000

  w_x = 40
  w_y = 30
  w_left = w_x * 16
  w_right = w_left + 256
  w_top = (48 - w_y) * 16
  w_bottom = w_top - 128

    'number of custom interleaved characters              
  nuchars = 4  'has to be a multiple of 2      'you must put the correct # here for alignment later

OBJ

  vga     : "VGA_1024x768_Tile_Driver_With_Cursor"
  mouse   : "mouse"
  gr      : "graphics"

  
VAR

  long  col, row, color
  long  boxcolor, boxptr

  long  array[tiles/2]
  long  cursor[1+32]

  long  cursor_x, cursor_y, cursor_col, cursor_def

    'for custom characters
  word  user_charbase
  

PUB start | i, j, k

    '64 byte align the user characters
  user_charbase := @uchar & $FFC0 'destination
  longmove(user_charbase,@uchar,16*nuchars)

  'start mouse and set bound parameters
  mouse.start(24, 25)
  mouse.bound_limits(0, 0, 0, 1023, 767, 0)
  mouse.bound_scales(1, 1, 0)
  mouse.bound_preset(512, 384, 0)

  'start vga tile driver
  vga.start(16, @array, @vgacolors, @cursor_x, 0, 0)

  'start and setup graphics
  gr.start
  gr.setup(16, 8, 128, 64, bitmap_base)

  'fill screen with text
  print($100)
  repeat 100
    Print($200+0)      '$200 tells modified Print() that this is a user character  (first character is 0!)
    uPrint(1)          'don't add anything for uPrint  
    Print($200+2)
    uPrint(3)


  'print_string(@text)

  'box(30, 1, 0, string("Compile"))
  'box(40, 1, 1, string("Execute"))
  'box(50, 1, 2, string("Quit"))

  'make some graphics tiles on the screen
  repeat i from 0 to 7
    repeat j from 0 to 15
      array.word[cols * (w_y + i) + j + w_x] := display_base + i << 6 + j <<9 + 21

      
    
  'keep updating screen
  repeat
    'do some graphics
    gr.clear

    gr.colorwidth(3,0)
    repeat i from 1 to 8
      gr.vec(0, 0, (k & $7F) << 3 + i << 4, k << 6 + i << 8, @vecdef)

    gr.textmode(10,7,6,5)
    gr.colorwidth(1,7)
    i := ||(k>>5 // 10) + "0"
    gr.textarc(0, 0, 80, 20, -k << 7 / 3, @i)
      
    gr.textmode(2,4,6,5)
    gr.colorwidth(2,2)
    gr.textarc(0, 0, 50, 40, k << 6, @@strings[k >> 8 & 3])

    gr.copy(display_base)
    k++

    'set mouse cursor according to area
    if cursor_x => w_left and cursor_x < w_right and cursor_y => w_bottom and cursor_y < w_top
      cursor_def := 1
      cursor_col := $FC
    elseif cursor_y => 400
      cursor_def := 0
      cursor_col := $A8
    else
      cursor_def := @propeller
      cursor_col := $FC

    'update mouse position
    cursor_x := mouse.bound_x
    cursor_y := mouse.bound_y



PRI box(left, top, clr, str) | width, height, x, y, i

' Draw a box

  boxcolor := $10 + clr
  color := clr + 5

  width := strsize(str)
  height := 2

  boxptr := top * cols + left
  boxchr($0)
  repeat i from 1 to width
    boxchr($C)
  boxchr($8)
  repeat i from 1 to height
    boxptr := (top + i) * cols + left
    boxchr($A)
    boxptr += width
    boxchr($B)
  boxptr := (top + height + 1) * cols + left
  boxchr($1)
  repeat i from 1 to width
    boxchr($D)
  boxchr($9)

  col := left + 1
  row := top + 1
  print_string(str)
  

PRI boxchr(c): i

  array.word[boxptr++] := $8000 + c << 6 + boxcolor


PRI print_string(ptr)

  repeat while byte[ptr]
    print(byte[ptr++])
    

PRI print(c) | i, k

'' Print a character
''
''       $0D = new line
''  $20..$FF = character
''$200..$2FF = user character
''      $100 = clear screen
''      $101 = home
''      $108 = backspace
''$110..$11F = select color

  case c
    $0D:                'return?
      newline

    $20..$FF:           'character?
      k := color << 1 + c & 1
      i := $8000 + (c & $FE) << 6 + k
      array.word[row * cols + col] := i
      array.word[(row + 1) * cols + col] := i | $40
      if ++col == cols
        newline
    $200..$2FF:         'user character
      c-=$200
      k := color << 1 + c & 1
      i := user_charbase + (c & $FE) << 6 + k
      array.word[row * cols + col] := i
      array.word[(row + 1) * cols + col] := i + $40
      if ++col == cols
        newline    

    $100:               'clear screen?
      wordfill(@array, spacetile, tiles)
      col := row := 0

    $101:               'home?
      col := row := 0

    $108:               'backspace?
      if col
        col--

    $110..$11F:         'select color?
      color := c & $F


PRI newline | i

  col := 0
  if (row += 2) == rows
    row -= 2
    'scroll lines
    repeat i from 0 to rows-3
      wordmove(@array.word[i*cols], @array.word[(i+2)*cols], cols)
    'clear new line
    wordfill(@array.word[(rows-2)*cols], spacetile, cols<<1)
      
PRI nuchr(c, nucolor)    'prints a user defined 4-color character, 'c', with color index, 'nucolor' 

  array.word[row * cols + col] := user_charbase + (c<<6)  + nucolor

PRI uPrint(c)|i,k
      k := color << 1 + c & 1
      i := user_charbase + (c & $FE) << 6 + k
      array.word[row * cols + col] := i
      array.word[(row + 1) * cols + col] := i + $40
      if ++col == cols
        newline
  
DAT

propeller long

  long %00000000_00000000_00000000_00000000
  long %01111110_00000000_00000011_11111000
  long %11111111_11110001_10111111_11111110
  long %11111111_11111111_11111111_11111111
  long %01111111_11111101_10001111_11111111
  long %00011111_11000001_10000000_01111110
  long %00000000_00000011_11000000_00000000
  long %00000000_00000011_11000000_00000000
  long %00000000_00000001_10000000_00000000
  long %00000000_00001111_11110000_00000000
  long %00000000_01111001_10011110_00000000
  long %00000001_11110011_11001111_10000000
  long %00000011_11100011_11000111_11000000
  long %00000111_11000111_11100011_11100000
  long %00001111_10000111_11100001_11110000
  long %00011111_10000111_11100001_11111000
  long %00011111_00000111_11100000_11111000
  long %00111111_00001111_11110000_11111100
  long %00111110_00001111_11110000_01111100
  long %00111110_00001111_11110000_01111100
  long %01111110_00001111_11110000_01111110
  long %01111100_00001111_11110000_00111110
  long %01111100_00011111_11111000_00111110
  long %01111111_11111111_11111111_11111110
  long %01111111_11110000_00001111_11111110
  long %01111000_00000000_00000000_00011110
  long %01100000_00000000_00000000_00000110
  long %00111100_00000000_00000000_00111100
  long %00001111_11110000_00001111_11110000
  long %00000011_11111111_11111111_11000000
  long %00000000_00011111_11111000_00000000
  long %00000000_00000000_00000000_00000000
  byte 15,15
  
vgacolors long

  long $3C043C04       'lt grey on dk grey
  long $3C3C0404
  long $C000C000       'red
  long $C0C00000
  long $30003000       'green
  long $30300000
  long $0C000C00       'blue
  long $0C0C0000
  long $FC00FC00       'white
  long $FCFC0000
  long $FF80FF80       'red/white
  long $FFFF8080
  long $FF20FF20       'green/white
  long $FFFF2020
  long $FF28FF28       'cyan/white
  long $FFFF2828
  long $C0408080       'redbox
  long $3010F020       'greenbox
  long $3C142828       'cyanbox
  long $FC54A8A8       'greybox
  long $3C14FF28       'cyanbox+underscore
  long $F030C050       'graphics colors

'text file "monitor.spin"
'     byte 0

vecdef word $4000+$2000/3*0         'triangle
       word 50
       word $8000+$2000/3*1+1
       word 50
       word $8000+$2000/3*2-1
       word 50
       word $8000+$2000/3*0
       word 50
       word 0

strings word @s0,@s1,@s2,@s3
s0      byte "1024x768 Tile Driver",0
s1      byte "** With Cursor **",0
s2      byte "Plug in a mouse!",0
s3      byte  0

padding LONG  7[16] 'alignment padding for the following user defined characters     
uchar
        LONG %00001010_10000000_00000001_01010000
        LONG %00001010_10100000_01010101_01010000
        LONG %00001010_10101101_01010101_01010000
        LONG %00001010_10111111_11010101_01010000
        LONG %00001010_11111111_11010101_01010000
        LONG %00001010_11111111_11110101_01010000
        LONG %00001011_11111111_11111111_01010000
        LONG %00001111_11111111_11111111_11010000
        LONG %00001111_11111111_11111111_11110000
        LONG %00011111_11111111_11111111_11110000
        LONG %00011111_11111111_11111111_11110000
        LONG %00011111_11111111_11111111_11111000
        LONG %01011111_11111111_11111111_11111000
        LONG %01011111_11111111_11111111_11111010
        LONG %01011111_11111111_11111111_11111010
        LONG %01011111_11111111_11111111_11111010
        LONG %01011111_11111111_11111111_11111010
        LONG %01011111_11111111_11111111_11111000
        LONG %01011111_11111111_11111111_11111000
        LONG %00011111_11111111_11111111_11111000
        LONG %00011111_11111111_11111111_11110000
        LONG %00011111_11111111_11111111_11110000
        LONG %00001111_11111111_11111111_11010000
        LONG %00001111_11111111_11111111_11010000
        LONG %00001011_11111111_11111111_11010000
        LONG %00001010_11111111_11111101_01010000
        LONG %00001010_10111111_11110101_01010000
        LONG %00001010_10101111_11110101_01010000
        LONG %00001010_10101011_11010101_01010000
        LONG %00001010_10101010_00010101_01010000
        LONG %00001010_10100000_00000101_01010000
        LONG %00001010_10000000_00000101_01010000

        LONG %11111111_11111111_11111111_11111111
        LONG %11000000_00000000_00000000_00000011
        LONG %11000000_00000000_00000000_00000011
        LONG %11000000_00000000_00000000_00000011
        LONG %11000000_00000010_10101111_00000011
        LONG %11000000_00001010_10101111_00000011
        LONG %11000000_00101000_00001111_00000011
        LONG %11000000_10100000_00001111_00000011
        LONG %11000000_10100000_00001111_00000011
        LONG %11000010_10000000_00001111_00000011
        LONG %11000010_10000000_00001111_00000011
        LONG %11000010_10000000_00001111_00000011
        LONG %11000000_10100000_00001111_00000011
        LONG %11000000_10101000_00001111_00000011
        LONG %11000000_00001010_00001111_00000011
        LONG %11000000_00000010_10101111_00000011
        LONG %11000000_00001010_10101111_00000011
        LONG %11000000_00101000_00001111_00000011
        LONG %11000000_00101000_00001111_00000011
        LONG %11000000_00100000_00001111_00000011
        LONG %11000000_10100000_00001111_00000011
        LONG %11000000_10100000_00001111_00000011
        LONG %11000010_10000000_00001111_00000011
        LONG %11000011_11010101_01011111_00000011
        LONG %11000011_11010101_01011111_00000011
        LONG %11000000_00000000_00000000_00000011
        LONG %11000000_00000000_00000000_00000011
        LONG %11000000_00000000_00000000_00000011
        LONG %11000000_00000000_00000000_00000011
        LONG %11000000_00000000_00000000_00000011
        LONG %11000000_00000000_00000000_00000011
        LONG %11111111_11111111_11111111_11111111





        

